#ifndef __COMIDASLX_DLL_H_
#define __COMIDASLX_DLL_H_

#include "ComidasCommon.h"
#ifdef __cplusplus
extern "C"{
#endif

// Device ID definition // 
#define COMI_LX101	0xA101
#define COMI_LX102	0xA102
#define COMI_LX103	0xA103
#define COMI_LX201	0xA201
#define COMI_LX202	0xA202
#define COMI_LX203	0xA203
#define COMI_LX301	0xA301
#define COMI_LX401	0xA401
#define COMI_LX402	0xA402
#define COMI_LX501	0xA501

#define AI_SINGLE 	1  /* Single Ended input */
#define AI_DIFF		0  /* Differential input */

enum {TS_NONE, TS_ANALOG, TS_DIGITAL};
enum {TE_POSITIVE, TE_NEGATIVE};
enum {TM_INITIAL, TM_MIDDLE};
enum {CMC_DIR_N, CMC_DIR_P}; // Direction
enum {CMC_VMODE_C, CMC_VMODE_T, CMC_VMODE_S}; // Speed mode : Constant, Trapezoidal, S-curve //

#ifdef COMIDASLXDLL_EXPORTS
 #define COMIDAS_API __declspec(dllexport)
#else
 #ifdef _COMIDASLX_LOADER_C_
  #define EXTERN
 #else
  #define EXTERN extern
 #endif
 BOOL COMILX_LoadDll(void);
 void COMILX_UnloadDll(void);
 EXTERN HANDLE	(*COMILX_LoadDevice) (COMIDAS_DEVID deviceID, ULONG instance);
 EXTERN void	(*COMILX_UnloadDevice) (HANDLE hDevice);
 EXTERN void	(*COMILX_SetComiBus) (HANDLE hDevice, BOOL bEnable, BOOL bIsMaster);
 //___________ General A/D Functions _____________________________________________//
 EXTERN void	(*COMILX_AD_SetInputType) (HANDLE hDevice, int nInputMode);
 EXTERN BOOL	(*COMILX_AD_SetRange) (HANDLE hDevice, int ch, float vmin, float vmax);
 EXTERN int		(*COMILX_AD_GetDigit) (HANDLE hDevice, int ch);
 EXTERN float	(*COMILX_AD_GetVolt) (HANDLE hDevice, int ch);
 //___________ Unlimited A/D Scan for LX10x _____________________________________________//
 EXTERN long	(*COMILX_US1_Start) (HANDLE hDevice, int nNumChannel, int *pChanList,
			UINT dwScanFreq, UINT nBufSize, int nTrsMethod);
 EXTERN void	(*COMILX_US1_Stop) (HANDLE hDevice, BOOL bReleaseBuf);
 EXTERN long	(*COMILX_US1_ChangeScanFreq) (HANDLE hDevice, UINT dwScanFreq);
 EXTERN void	(*COMILX_US1_ResetCount) (HANDLE hDevice);
 EXTERN short*	(*COMILX_US1_GetBuffer) (HANDLE hDevice);
 EXTERN ULONG	(*COMILX_US1_CurCount) (HANDLE hDevice);
 EXTERN UINT	(*COMILX_US1_SBPos) (HANDLE hDevice, int chOrder, ULONG scanCount);
 EXTERN BOOL	(*COMILX_US1_ReleaseBuf) (HANDLE hDevice);
 EXTERN short	(*COMILX_US1_RetrvOne) (HANDLE hDevice, int chOrder, ULONG scanCount);
 EXTERN ULONG	(*COMILX_US1_RetrvChannel) (HANDLE hDevice, int chOrder, ULONG startCount, 
			int maxNumData, void *pDestBuf, TComiVarType VarType);
 EXTERN UINT	(*COMILX_US1_RetrvBlock) (HANDLE hDevice, UINT startCount, int maxNumScan, 
			void *pDestBuf, TComiVarType VarType);
 //___________ Unlimited A/D Scan for LX20x _____________________________________________//
 EXTERN void	(*COMILX_US2_SetTriggerEvent) (HANDLE hDevice, int nInputSource,
					int nEdgeType, int nTrgMode, float fAiRef, float fAiRefBand);
 EXTERN double	(*COMILX_US2_Start) (HANDLE hDevice, int nNumChannel, int *pChanList, UINT nScanFreq,
								   USHORT nBufSizeGain, BOOL bPauseAtBufFull);
 EXTERN void	(*COMILX_US2_Resume) (HANDLE hDevice);
 EXTERN double	(*COMILX_US2_ChangeScanFreq) (HANDLE hDevice, UINT dwScanFreq);
 EXTERN ULONG	(*COMILX_US2_DmaCount) (HANDLE hDevice);
 EXTERN BOOL	(*COMILX_US2_IsBufFull) (HANDLE hDevice);
 EXTERN short*	(*COMILX_US2_GetBuffer) (HANDLE hDevice, int chOrder);
 EXTERN ULONG	(*COMILX_US2_RetrvChannel) (HANDLE hDevice, int chOrder, ULONG startCount,
						int maxNumData, void *pDestBuf, TComiVarType VarType);
 EXTERN void	(*COMILX_US2_Stop) (HANDLE hDevice, BOOL bReleaseBuf);
 EXTERN BOOL	(*COMILX_US2_ReleaseBuf) (HANDLE hDevice);
 //___________ DIO Common __________________________________________________//
 EXTERN void	(*COMILX_DIO_SetUsage) (HANDLE hDevice, int usage);
 //__________ D/I Functions ________________________________________________//
 EXTERN int		(*COMILX_DI_GetOne) (HANDLE hDevice, int ch);
 EXTERN DWORD	(*COMILX_DI_GetAll) (HANDLE hDevice);
 //__________ D/O Functions ________________________________________________//
 EXTERN void	(*COMILX_DO_PutOne) (HANDLE hDevice, int ch, int status);
 EXTERN void	(*COMILX_DO_PutAll) (HANDLE hDevice, DWORD dwStatuses);
 //__________ Serial Digital Input/Output Functions ________________________//
 EXTERN BOOL	(*COMILX_SDIO_InitComm) (HANDLE hDevice);
 EXTERN BOOL	(*COMILX_SDIO_CheckModule) (HANDLE hDevice, int nModuleNo);
 EXTERN BOOL	(*COMILX_SDIO_SetDioUsage) (HANDLE hDevice, int nModuleNo, int nUsge);
 EXTERN BYTE	(*COMILX_SDIO_ReadLowByte) (HANDLE hDevice, int nModuleNo);
 EXTERN BYTE	(*COMILX_SDIO_ReadHighByte) (HANDLE hDevice, int nModuleNo);
 EXTERN USHORT	(*COMILX_SDIO_ReadWord) (HANDLE hDevice, int nModuleNo);
 EXTERN BOOL	(*COMILX_SDIO_WriteLowByte) (HANDLE hDevice, int nModuleNo, BYTE bValue);
 EXTERN BOOL	(*COMILX_SDIO_WriteHighByte) (HANDLE hDevice, int nModuleNo, BYTE bValue);
 EXTERN BOOL	(*COMILX_SDIO_WriteWord) (HANDLE hDevice, int nModuleNo, USHORT wWord);
 //__________ D/A Functions ________________________________________________//
 EXTERN BOOL	(*COMILX_DA_Out) (HANDLE hDevice, int ch, float volt);
 EXTERN long	(*COMILX_WFM_Start) (HANDLE hDevice, int ch, float *pDataBuffer, 
						UINT nNumData, UINT nPPS, int nMaxLoops);
 EXTERN BOOL	(*COMILX_WFM_Reload) (HANDLE hDevice, int ch, float *pDataBuffer, UINT nNumData);
 EXTERN long	(*COMILX_WFM_RateChange) (HANDLE hDevice, int ch, ULONG nPPS);
 EXTERN long	(*COMILX_WFM_GetCurPos) (HANDLE hDevice, int ch);
 EXTERN long	(*COMILX_WFM_GetCurLoops) (HANDLE hDevice, int ch);
 EXTERN void	(*COMILX_WFM_Stop) (HANDLE hDevice, int ch);

 //__________ Counter Functions ____________________________________________//
 EXTERN ULONG 	(*COMILX_ReadCounter32) (HANDLE hDevice, int ch);
 EXTERN void 	(*COMILX_ClearCounter32) (HANDLE hDevice, int ch);

 //__________ Motion/Control Functions ____________________________________________//
  // Initialize functions //
 EXTERN void (*COMILX_MC_Reset) (HANDLE hDevice);
 EXTERN void (*COMILX_MC_SetBlockingMode) (HANDLE hDevice, BOOL bBlocking);
 EXTERN void (*COMILX_MC_SetWindowHandle) (HANDLE hDevice, ULONG hWnd);
 EXTERN void (*COMILX_MC_SetOutputMode) (HANDLE hDevice, int nChannel, int nOutputMode);
 EXTERN int	 (*COMILX_MC_GetOutputMode) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_SetInputMode) (HANDLE hDevice, int nChannel, int nInputMode, int nPulseLogic);
 EXTERN void (*COMILX_MC_GetInputMode) (HANDLE hDevice, int nChannel, int *pInputMode, int *pPulseLogic);
 EXTERN void (*COMILX_MC_SetSpeedRange) (HANDLE hDevice, int nChannel, double fMaxSpeed);
 EXTERN void (*COMILX_MC_GetSpeedRange) (HANDLE hDevice, int nChannel, double *fMinSpeed, double *fMaxSpeed);
 EXTERN void (*COMILX_MC_SetUnitDistance) (HANDLE hDevice, int nChannel, double fUnitDist);
 EXTERN void (*COMILX_MC_GetUnitDistance) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_SetUnitSpeed) (HANDLE hDevice, int nChannel, double fUnitSpeed);
 EXTERN void (*COMILX_MC_GetUnitSpeed) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_SetPosSrc) (HANDLE hDevice, int nChannel, int nSource);
 // Single Axis Motions //
 EXTERN void (*COMILX_MC_SetSpeedMode) (HANDLE hDevice, int nChannel, int nModeIndex);
 EXTERN void (*COMILX_MC_SetSpeed) (HANDLE hDevice, int nChannel, double fIniSpeed, double fWorkSpeed);
 EXTERN void (*COMILX_MC_SetAccel) (HANDLE hDevice, int nChannel, double fAccel, double fDecel);
 EXTERN void (*COMILX_MC_SetScurve) (HANDLE hDevice, int nChannel, double fSVacc, double fSVdec);
 EXTERN void (*COMILX_MC_StartVMove) (HANDLE hDevice, int nChannel, int nDirection);
 EXTERN void (*COMILX_MC_StartMove) (HANDLE hDevice, int nChannel, double fDistance);
 EXTERN void (*COMILX_MC_Move) (HANDLE hDevice, int nChannel, double fDistance);
 EXTERN void (*COMILX_MC_StartMoveTo) (HANDLE hDevice, int nChannel, double fPosition);
 EXTERN void (*COMILX_MC_MoveTo) (HANDLE hDevice, int nChannel, double fPosition);
 EXTERN void (*COMILX_MC_Stop) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_EmgStop) (HANDLE hDevice, int nChannel);
 EXTERN BOOL (*COMILX_MC_Done) (HANDLE hDevice, int nChannel);
 // Multi-Axes Motion //
 EXTERN void (*COMILX_MC_StartVMoveAll) (HANDLE hDevice, int nNumAxis, int nAxisList[], int nDirList[]);
 EXTERN void (*COMILX_MC_StartMoveAll) (HANDLE hDevice, int nNumAxis, int nAxisList[], double fDistList[]);
 EXTERN void (*COMILX_MC_MoveAll) (HANDLE hDevice, int nNumAxis, int nAxisList[], double fDistList[]);
 EXTERN void (*COMILX_MC_StopAll) (HANDLE hDevice, int nNumAxis, int nAxisList[]);
 EXTERN void (*COMILX_MC_EmgStopAll) (HANDLE hDevice, int nNumAxis, int nAxisList[]);
 EXTERN BOOL (*COMILX_MC_AllDone) (HANDLE hDevice, int nNumAxis, int nAxisList[]);
 // Coordinated Motion //
 EXTERN BOOL (*COMILX_MC_MapAxes) (HANDLE hDevice, int nMapIndex, unsigned char bMapMask);
 EXTERN void (*COMILX_MC_SetSpeedModeMx) (HANDLE hDevice, int nMapIndex, int nModeIndex);
 EXTERN void (*COMILX_MC_SetSpeedMx) (HANDLE hDevice, int nMapIndex, double fSpeed, double fAccel);
 EXTERN void (*COMILX_MC_StartLine) (HANDLE hDevice, int nMapIndex, double fDistList[]);
 EXTERN void (*COMILX_MC_Line) (HANDLE hDevice, int nMapIndex, double fDistList[]);
 EXTERN void (*COMILX_MC_StartLineTo) (HANDLE hDevice, int nMapIndex, double fPosList[]);
 EXTERN void (*COMILX_MC_LineTo) (HANDLE hDevice, int nMapIndex, double fPosList[]);
 EXTERN void (*COMILX_MC_StartArc_a) (HANDLE hDevice, int nMapIndex, double fXCentOffset, double fYCentOffset, double fEndAngle);
 EXTERN void (*COMILX_MC_Arc_a) (HANDLE hDevice, int nMapIndex, double fXCentOffset, double fYCentOffset, double fEndAngle);
 EXTERN void (*COMILX_MC_StartArc_p) (HANDLE hDevice, int nMapIndex, double fXCentOffset, double fYCentOffset, double fXEndPointDist, double fYEndPointDist, int nDir);
 EXTERN void (*COMILX_MC_Arc_p) (HANDLE hDevice, int nMapIndex, double fXCentOffset, double fYCentOffset, double fXEndPointDist, double fYEndPointDist, int nDir);
 EXTERN void (*COMILX_MC_StartArcTo_a) (HANDLE hDevice, int nMapIndex, double fXCent, double fYCent, double fEndAngle);
 EXTERN void (*COMILX_MC_ArcTo_a) (HANDLE hDevice, int nMapIndex, double fXCent, double fYCent, double fEndAngle);
 EXTERN void (*COMILX_MC_StartArcTo_p) (HANDLE hDevice, int nMapIndex, double fXCent, double fYCent, double fXEndPos, double fYEndPos, int nDir);
 EXTERN void (*COMILX_MC_ArcTo_p) (HANDLE hDevice, int nMapIndex, double fXCent, double fYCent, double fXEndPos, double fYEndPos, int nDir);
 EXTERN BOOL (*COMILX_MC_MxDone) (HANDLE hDevice, int nMapIndex);
 // Overriding //
 EXTERN void (*COMILX_MC_OverrideSpeedSet) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_OverrideSpeedSetAll) (HANDLE hDevice, int nNumAxis, int nAxisList[]);
 EXTERN void (*COMILX_MC_OverrideMove) (HANDLE hDevice, int nChannel, double fNewDistance);
 EXTERN void (*COMILX_MC_OverrideMoveTo) (HANDLE hDevice, int nChannel, double fNewPosition);
 // Home Move //
 EXTERN void (*COMILX_MC_SetHomeConfig) (HANDLE hDevice, int nChannel, int nOrgMode, int nOrgLogic, int nEzCount, int nEzLogic, int nErcOut);
 EXTERN void (*COMILX_MC_HomeMove) (HANDLE hDevice, int nChannel, int nDirection, double fRvsVel);
 // Pulser Mode //
 EXTERN void (*COMILX_MC_SetPulserInputMode) (HANDLE hDevice, int nChannel, int nInputMode, BOOL bInverse);
 EXTERN void (*COMILX_MC_PulserHomeMove) (HANDLE hDevice, int nChannel, int nHomeType);
 EXTERN void (*COMILX_MC_StartPulserVMove) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_StartPulserMove) (HANDLE hDevice, int nChannel, double fDistance);
 EXTERN void (*COMILX_MC_PulserMove) (HANDLE hDevice, int nChannel, double fDistance);
 EXTERN void (*COMILX_MC_StartPulserMoveTo) (HANDLE hDevice, int nChannel, double fPosition);
 EXTERN void (*COMILX_MC_PulserMoveTo) (HANDLE hDevice, int nChannel, double fPosition);
 // List-Motion //
 EXTERN void (*COMILX_MC_BeginList) (HANDLE hDevice);
 EXTERN void (*COMILX_MC_EndList) (HANDLE hDevice);
 EXTERN void (*COMILX_MC_StartListMotion) (HANDLE hDevice);
 EXTERN void (*COMILX_MC_AbortListMotion) (HANDLE hDevice);
 EXTERN BOOL (*COMILX_MC_CheckListMotionDone) (HANDLE hDevice);
 // Reset //
 EXTERN void (*COMILX_MC_ResetAxis) (HANDLE hDevice, int nChannel);
 // Get/Set Status //
 EXTERN double (*COMILX_MC_GetCurSpeed) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_EnableActSpdChk) (HANDLE hDevice, long dwInterval);
 EXTERN void (*COMILX_MC_DisableActSpdChk) (HANDLE hDevice);
 EXTERN double (*COMILX_MC_GetActualSpeed) (HANDLE hDevice, int nChannel);
 EXTERN double (*COMILX_MC_GetPosition_A) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_SetPosition_A) (HANDLE hDevice, int nChannel, double fActualPos);
 EXTERN double (*COMILX_MC_GetPosition_C) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_SetPosition_C) (HANDLE hDevice, int nChannel, double fPosition);
 EXTERN long (*COMILX_MC_GetCount_A) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_SetCount_A) (HANDLE hDevice, int nChannel, long nCount);
 EXTERN long (*COMILX_MC_GetCount_C) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_SetCount_C) (HANDLE hDevice, int nChannel, long nCount);
 EXTERN long (*COMILX_MC_GetCount_D) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_SetCount_D) (HANDLE hDevice, int nChannel, long nCount);
 EXTERN long (*COMILX_MC_GetCount_G) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_SetCount_G) (HANDLE hDevice, int nChannel, long nCount);
 EXTERN long (*COMILX_MC_GetCount_R) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_SetCount_R) (HANDLE hDevice, int nChannel, long nCount);
 EXTERN int (*COMILX_MC_GetMotionStatus) (HANDLE hDevice, int nChannel);
 EXTERN int (*COMILX_MC_GetMioStatus) (HANDLE hDevice, int nChannel);
 // Set Config //
 EXTERN void (*COMILX_MC_SetMioCfgALM) (HANDLE hDevice, int nChannel, int nAlarmLogic, int nAlarmMode);
 EXTERN void (*COMILX_MC_GetMioCfgALM) (HANDLE hDevice, int nChannel, int *pAlarmLogic, int *pAlarmMode);
 EXTERN void (*COMILX_MC_SetMioCfgEL) (HANDLE hDevice, int nChannel, int nElMode);
 EXTERN void (*COMILX_MC_GetMioCfgEL) (HANDLE hDevice, int nChannel, int *pElMode);
 EXTERN void (*COMILX_MC_SetMioCfgINP) (HANDLE hDevice, int nChannel, BOOL bInpEnable, int nInpLogic);
 EXTERN void (*COMILX_MC_GetMioCfgINP) (HANDLE hDevice, int nChannel, BOOL *pInpEnable, int *pInpLogic);
 EXTERN void (*COMILX_MC_SetMioCfgERC) (HANDLE hDevice, int nChannel, int nErcLogic, int nErcOnTime);
 EXTERN void (*COMILX_MC_GetMioCfgERC) (HANDLE hDevice, int nChannel, int *pErcLogic, int *pErcOnTime);
 EXTERN void (*COMILX_MC_SetMioCfgSD) (HANDLE hDevice, int nChannel, BOOL bSdEnable, int nSdLogic, int nSdLatch, int nSdMode);
 EXTERN void (*COMILX_MC_GetMioCfgSD) (HANDLE hDevice, int nChannel, BOOL *pSdEnable, int *pSdLogic, int *pSdLatch, int *pSdMode);
 EXTERN void (*COMILX_MC_SetSoftLimit) (HANDLE hDevice, int nChannel, double fLimitP, double fLimitN);
 EXTERN void (*COMILX_MC_EnableSoftLimit) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_DisableSoftLimit) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_SetErrorCompare) (HANDLE hDevice, int nChannel, double fTol, int bEnable);
 EXTERN void (*COMILX_MC_SetGeneralCompare) (HANDLE hDevice, int nChannel, int nCmpSrc, int nCmpMethod, int nCmpAction, double fData);
 // Interrupt //
 EXTERN void (*COMILX_MC_MaskInterrupt) (HANDLE hDevice, int nChannel, long dwMask);
 EXTERN void (*COMILX_MC_EnableInterrupt) (HANDLE hDevice, HANDLE hEvent);
 EXTERN void (*COMILX_MC_DisableInterrupt) (HANDLE hDevice);
 EXTERN BOOL (*COMILX_MC_GetAxisIntState) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMILX_MC_GetIntStatus) (HANDLE hDevice, int nChannel, long *pErrorStatus, long *pEventStatus);
 
 //__________ Utility Functions ____________________________________________//
 EXTERN int		(*COMILX_LastError) (void);
 EXTERN const char* (*COMILX_ErrorString) (int nErrCode);
 EXTERN BOOL	(*COMILX_GetAvailDevList) (TComiDevList *pDevList);
 EXTERN BOOL	(*COMILX_GetDevInfo) (HANDLE hDevice, TComiDevInfo *pDevInfo);
 EXTERN void 	(*COMILX_GetResources) (HANDLE hDevice, PULONG pdwIntVect, PULONG pdwIoPorts,
					 int nNumPorts, PULONG pdwMemPorts, int nNumMemPorts);
 EXTERN void	(*COMILX_WriteMemPortDW) (HANDLE hDevice, ULONG dwPortBase, ULONG nOffset, DWORD dwOutVal);
 EXTERN DWORD	(*COMILX_ReadMemPortDW) (HANDLE hDevice, ULONG dwPortBase, ULONG nOffset);
 EXTERN void	(*COMILX_Write8402) (HANDLE hDevice, int ch, int addr, int data);
 EXTERN void	(*COMILX_WriteEEPR) (HANDLE hDevice, int addr, int data);
 EXTERN int		(*COMILX_ReadEEPR) (HANDLE hDevice, int addr);

#undef EXTERN
#endif

#ifdef __cplusplus
}
#endif

#endif
